import mongoose from "mongoose";
import jwt from "jsonwebtoken";
import Joi from "joi";
import { getEnv } from "#utils/env";
import { SIGNUP_ROLE } from "#constant/constant"

const UserSchema = new mongoose.Schema({
  firstName: {
    type: String,
  },
  lastName: {
    type: String,
  },
  email: {
    type: String,
  },
  password: {
    type: String,
  },
  phone: {
    type: Number,
  },
  iama: {
    type: String,
    enum: SIGNUP_ROLE
  },
  isVerified: {
    type: Boolean,
    default:false
  }
}, { timestamps: true });

UserSchema.methods.generateAuthToken = function () {
  const payload = { _id: this._id, name: this.name, email: this.email };
  const secret = getEnv('JWT_SECRET');
  const options = { expiresIn: '1d' }
  return jwt.sign(payload, secret, options);
}

function validateUser(user) {
  const schema = Joi.object({
    firstName: Joi.string().required(),
    lastName: Joi.string().required(),
    email: Joi.string().required().email(),
    phone: Joi.number().required(),
    password: Joi.string().min(8).max(255).required(),
    iama: Joi.string().valid(...SIGNUP_ROLE).required()
  });
  return schema.validate(user);
}

const User = mongoose.model("User", UserSchema);

export { User, validateUser as validate };